#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <string.h>
#include <linux/gpio.h>
#include <limits.h>

#include <pthread.h>

double total=0.0;

#define MATRIX_SIZE 1024ULL

static void *busy_thread(void *argument) {

	double s,*a,*b,*c;
        int i,j,k;
	int size=MATRIX_SIZE;

	a=calloc(size*size,sizeof(double));
        b=calloc(size*size,sizeof(double));
        c=calloc(size*size,sizeof(double));

	if ((!a) || (!b) || (!c)) {
		fprintf(stderr,"Error allocating RAM!\n");
		return NULL;
	}

	while(1) {

        /* Init with some data */
        for(i=0;i<size;i++) {
                for(j=0;j<size;j++) {
                        a[(i*size)+j]=(double)i*(double)j+total;
                        b[(i*size)+j]=(double)i/(double)(j+5);
                        c[(i*size)+j]=0.0;
                }
        }

        /* Matrix multiply */
        for(i=0;i<size;i++) {
                for(j=0;j<size;j++) {
                        for(k=0;k<size;k++) {
                                // c[i][j]+=a[i][k]*b[k][j]
                                c[(i*size)+j]+=a[(i*size)+k]*b[(k*size)+j];
                        }
                }
        }


	s=0.0;
        for(i=0;i<size;i++) {
                for(j=0;j<size;j++) {
                        s+=c[(i*size)+j];
                }
        }

	total+=s;


	}

//	while(1) {
//		asm("");
//	}

	return NULL;
}




int main(int argc, char **argv) {

	pthread_t *threads;
	int i,result;

	int max_count=10;

	if (argc>1) {
		max_count=atoi(argv[1]);
		printf("Setting busy threads to %d\n",max_count);
	}
	else {
		printf("busy threads is %d\n",max_count);
	}

	/* allocate the result arrays */
	threads=calloc(max_count,sizeof(pthread_t));
	if (threads==NULL) {
		fprintf(stderr,"Error allocating memory...\n");
		return -1;
	}

	for(i=0;i<max_count;i++) {
		/* start the writing thread */
		result = pthread_create(
                	&threads[i],
                	NULL,
                	busy_thread,
			NULL);
	}

	(void) result;

	/* wait for both threads to finish */
	for(i=0;i<max_count;i++) {
		pthread_join(threads[i],NULL);
	}

	printf("Got total: %lf\n",total);

	return 0;
}
