#include <stddef.h>
#include <stdint.h>

#include "lib/printk.h"

#include "drivers/drivers.h"

#include "drivers/console/console_io.h"
#include "drivers/framebuffer/framebuffer.h"
#include "drivers/framebuffer/framebuffer_console.h"
#include "drivers/led/led.h"
#include "drivers/timer/timer.h"
#include "drivers/serial/serial.h"
#include "drivers/pmu/arm-pmu.h"

void drivers_init_all(void) {

	uint32_t framebuffer_width=640,framebuffer_height=480;

	/**************************/
	/* Device Drivers	  */
	/**************************/

	/* Set up console */
	console_init();

	/* Set up ACT LED */
	act_led_init();

	/* Set up timer */
	timer_init();

	/* set up framebuffer */
	framebuffer_init(framebuffer_width,framebuffer_height,24);
	framebuffer_console_init();

	serial_enable_interrupts();

}
