#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#define MAX_BBLOCKS 200000

static int initialized=0,end_of_program=0;

int bb_inst_counter[MAX_BBLOCKS];
//,bb_iterations[MAX_BBLOCKS],
//    bb_proc_dyn_instr[MAX_BBLOCKS];

long dyn_instr,interval_num,grain_size,new_interval,last_procstart;
long total_instr=0;

int bbtrace,procstarts,pcstarts;

char bb_error[]="Too many bblocks!\n";
char t_string[]="T";
char c_string[]=":";
char n_string[]="\n";
char s_string[]="   ";


static void dump_int(int fd,int val) {
    char buffer[10];
    int q,r,temp,i;
   
    temp=val;
   
    i=9;
   
    do {
     
       q=temp/10;
       r=temp%10;
       
       buffer[i]=r+'0';
       
       temp=q;
       i--;
    } while(temp);
    
    write(fd,buffer+i+1,9-i);
   
}

void take_stats(int total_bbs,int this_bb,int instperblock,
		int firstblock,char *func_name) {

   int i;
   
   if (end_of_program) return;
   
   if (!initialized) {

      if (total_bbs>MAX_BBLOCKS) {
	 write(1,bb_error,19);
         exit(-5);
      }
      
      dyn_instr=0;
      interval_num=1;
      grain_size=100000;
      new_interval=1;
      
      bbtrace=open("out.bb",O_WRONLY | O_CREAT | O_TRUNC);
/*      procstarts=open("out.procstarts",O_WRONLY);
      pcstarts=open("out.pcstarts",O_WRONLY);
      
      fprintf(procstarts,"%10s %20s %16s %16s\n","Interval","Procname","Iterations",
	      "Distance");
      fprintf(pcstarts,"%10s %16s %16s\n","Interval","PC","Iterations");
*/
      initialized=1;
   }
   
   bb_inst_counter[this_bb]+=instperblock;
//   bb_iterations[this_bb]++;
   
   total_instr+=instperblock;
   
   if (firstblock) {
//      bb_proc_dyn_instr[this_bb]=dyn_instr;
//      bb_ProcName[bbnum]=func_name;
      last_procstart   = this_bb;
      if (new_interval) {
	 new_interval=0;
	 /*
	 fprintf(procstarts,"%10ld %20s %16ld %16ld\n",
		 interval_num,
		 func_name,
		 bb_iterations[this_bb],
		 dyn_instr);
	 fflush(procstarts);
	 */
      }
   }

   dyn_instr+=instperblock;
   
   if (dyn_instr>grain_size) {
      new_interval=1;
  
      write(bbtrace,t_string,1);  /* print a T */
      for(i=0;i<total_bbs;i++) {
	 if (bb_inst_counter[i]!=0) {
	    write(bbtrace,c_string,1); /* Print a colon */
	    dump_int(bbtrace,i);       /* Print the block number */
	    write(bbtrace,c_string,1); /* Print a colon */
	    dump_int(bbtrace,bb_inst_counter[i]); /* print the count */
	    write(bbtrace,s_string,3); /* Print 3 spaces */
	    
	    //fprintf(bbtrace,":%d:%ld   ",i,bb_inst_counter[i]);
	    
	    
	    bb_inst_counter[i]=0;
	 }
      }
      write(bbtrace,n_string,1);

      
//      fprintf(pcstarts,"%10ld %16p %16d\n",
//	      interval_num+1,pc,bb_iterations[this_bb]);
      
      dyn_instr-= grain_size;
      interval_num++;
   }

//   printf("VMW: %d %d %d\n",total_funcs,this_func,initialized);
}

void end_program() {
   end_of_program=1;
/*   
   printf("VMW: At EXIT!  Closing down...\n");
   if (initialized) {
      fclose(bbtrace);
      fclose(procstarts);
      fclose(pcstarts);
   }
 */
}


/*
int main(int argc, char **argv) {
 
   int i;
   
   for(i=0;i<5000;i++) {
      take_stats(10,rand()%10,50,0,"blargh");
   }
 
   return 0;
}
*/
