#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#define MAX_BBLOCKS 200000
#define GRAIN_SIZE  100000000

static int initialized=0,end_of_program=0;

int bb_inst_counter[MAX_BBLOCKS];

int dyn_instr,interval_num,bbtrace;

char bb_error[]="Too many bblocks!\n";
char t_string[]="T";
char c_string[]=":";
char n_string[]="\n";
char s_string[]="   ";


static void dump_int(int fd,int val) {
    char buffer[10];
    int q,r,temp,i;
   
    temp=val;
   
    i=9;
   
    do {
     
       q=temp/10;
       r=temp%10;
       
       buffer[i]=r+'0';
       
       temp=q;
       i--;
    } while(temp);
    
    write(fd,buffer+i+1,9-i);
   
}

void take_stats(int total_bbs,int this_bb,int instperblock,
		int firstblock,char *func_name) {

   int i;

   if (end_of_program) return;
   
   if (!initialized) {

      if (total_bbs>MAX_BBLOCKS) {
	 write(1,bb_error,19);
         exit(-5);
      }
      
      bbtrace=open(func_name,O_WRONLY | O_CREAT | O_TRUNC,S_IRUSR|S_IWUSR);

      initialized=1;
   }
   
   bb_inst_counter[this_bb]+=instperblock;   
   dyn_instr+=instperblock;
   
   if (dyn_instr>GRAIN_SIZE) {
  
      write(bbtrace,t_string,1);  /* print a T */
      for(i=0;i<total_bbs;i++) {
	 if (bb_inst_counter[i]!=0) {
	    write(bbtrace,c_string,1); /* Print a colon */
	    dump_int(bbtrace,i);       /* Print the block number */
	    write(bbtrace,c_string,1); /* Print a colon */
	    dump_int(bbtrace,bb_inst_counter[i]); /* print the count */
	    write(bbtrace,s_string,3); /* Print 3 spaces */
	    
	    //fprintf(bbtrace,":%d:%ld   ",i,bb_inst_counter[i]);
	    	    
	    bb_inst_counter[i]=0;
	 }
      }
      write(bbtrace,n_string,1);
      
      dyn_instr-= GRAIN_SIZE;
   }

}

void end_program() {
   end_of_program=1;
}


/*
int main(int argc, char **argv) {
 
   int i;
   
   for(i=0;i<5000;i++) {
      take_stats(10,rand()%10,50,0,"blargh");
   }
 
   return 0;
}
*/
