#include <stdio.h>

#include "BPatch.h"
#include "BPatch_Vector.h"
#include "BPatch_thread.h"
#include "BPatch_Set.h"
#include "BPatch_flowGraph.h"
#include "BPatch_function.h"
#include "BPatch_point.h"
#include <iostream>
#include <fcntl.h>
using namespace std;

int main(int argc, char *argv[]) {

   unsigned int basic_block=0,total_blocks=0,instperblock=0,entrypoint=0;
   char name_buffer[256],library_name[256],our_path[256];
   unsigned int i,j,our_argc,num_procedures=0,dyninst_already_warn=0,libelf_already_warn=0;
   unsigned int skip_function;
   const char **our_argv;
   
   FILE *functions;

   BPatch bpatch;
   BPatch_process *appProc;
   BPatch_image *appImage;
   BPatch_Vector<BPatch_function *> *all_procedures;
   BPatch_Vector<BPatch_point*> *take_p;
   BPatch_Vector<BPatch_function*> take_f;
   BPatch_flowGraph *cfg;
   BPatch_module *module;
      
   if (argc<2) {
      printf("\nUseage: %s path executable <arguments>\n\n",argv[0]);
      exit(1);
   }
   
   our_argc=argc-2;
   our_argv=(const char **)calloc(argc,sizeof(char *));

   for(i=0;i<our_argc;i++) {
      our_argv[i]=argv[i+2];
      //printf("our_argv[%i]=%s\n",i,our_argv[i]);
   }
   /* argv list must be null terminated */
   our_argv[argc-1]=NULL;
   
   /* Open the process of interest */
   appProc  = bpatch.processCreate(our_argv[0],our_argv);
   appImage = appProc->getImage();

   /* get a vector of all the procedurs */
   all_procedures = appImage->getProcedures();
   num_procedures = all_procedures->size();
   
   /* find our instrumentation function */
   appImage->findFunction("take_stats",take_f);
   take_p = take_f[0]->findPoint(BPatch_entry);

   

   
   /* get total basic block count */
   for(i=0;i<num_procedures;i++) {
      
      skip_function=0;

      module=(*all_procedures)[i]->getModule();
      
	 
      cfg = (*all_procedures)[i]->getCFG();
      
      BPatch_Set<BPatch_basicBlock*> allBlocks;
      
      cfg->getAllBasicBlocks(allBlocks);
      
      total_blocks+=allBlocks.size();      
   }
   
//   printf("VMW: Total blocks=%d\n",total_blocks);

   basic_block=1;


   sprintf(our_path,"%s.functions",argv[1]);
   functions=fopen(our_path,"w");
   if (functions==NULL) {
      exit(-1);
   }
   fprintf(functions,"%i\n",all_procedures->size());
   
   sprintf(our_path,"%s.bb",argv[1]);
   
   
   for(i=0;i<num_procedures;i++) {  
      
      skip_function=0;

      module=(*all_procedures)[i]->getModule();
      
      if (module->libraryName()!=NULL) {
	 strncpy(library_name,module->libraryName(),256);

         if (strstr(library_name,"dyninst")) {
	    skip_function=1;
	    if (!dyninst_already_warn) {
	       printf("Ignoring code in library %s\n",library_name);
	       dyninst_already_warn=1;
	    }
         }

         if (strstr(library_name,"libelf")) {
	    skip_function=1;
	    if (!libelf_already_warn) {
	       printf("Ignoring code in library %s\n",library_name);
	       libelf_already_warn=1;
	    }
         }
      }
      
         /* get the name of the function */
      (*all_procedures)[i]->getName(name_buffer,256);
      
      if (!strcmp(name_buffer,"take_stats")) {
	 printf("Skipping take_stats\n");
	 skip_function=1;
      }
      
      if (!strcmp(name_buffer,"end_program")) {
	 printf("Skipping end_program\n");
	 skip_function=1;
      }
      
      if (!strcmp(name_buffer,"dump_int")) {
	 printf("Skipping dump_int\n");
	 skip_function=1;
      }
      
      
      if (skip_function) continue;
      
      
      BPatch_flowGraph *cfg= (*all_procedures)[i]->getCFG();
      
      BPatch_Set<BPatch_basicBlock*> allBlocks;
      
      
      cfg->getAllBasicBlocks(allBlocks);
      
      BPatch_basicBlock** elements = new BPatch_basicBlock*[allBlocks.size()];
      allBlocks.elements(elements);

      appProc->beginInsertionSet();

      fprintf(functions,"%i %s %s\n",
	      i,
	      (*all_procedures)[i]->getName(name_buffer,256),
	      module->libraryName() );

      fprintf(functions,"\t");
      
      for(j=0;j<allBlocks.size();j++) {

         fprintf(functions,"%d ",basic_block);
	 
	 BPatch_Vector<BPatch_snippet*> take_stat_args; 
      
	 BPatch_basicBlock *block = elements[j];
	 
	 /* is it an entry point?*/
	 entrypoint=block->isEntryBlock();
	 
	 /* don't count library functions */

//	 if ( (entrypoint) && ( (*p)[i]->libraryName()!=NULL) ){
	 //if (block->libraryName()!=NULL) 
//	      entrypoint=0;
//	 }
	 
	 BPatch_Vector<BPatch_instruction *> *insns = block->getInstructions();
	 	 
	 instperblock=insns->size();
	 BPatch_point *inst_pt=(*insns)[0]->getInstPoint();
	 
	 if (inst_pt==NULL) {
	    continue;  
	 }
	 	  
         BPatch_constExpr block_count(total_blocks);
         BPatch_constExpr which_bblock(basic_block);
	 BPatch_constExpr num_insts(instperblock);
	 BPatch_constExpr is_first(entrypoint);
         BPatch_constExpr funcname(our_path);

//	 if (basic_block%1000==0) printf("VMW: bb %d of %d\n",basic_block,total_blocks);
	 
//	 printf("Instrumenting: %d %d %d %d %s\n",total_blocks,basic_block,
//		instperblock,entrypoint,name_buffer);
	 
         take_stat_args.push_back(&block_count);
         take_stat_args.push_back(&which_bblock);
         take_stat_args.push_back(&num_insts);
         take_stat_args.push_back(&is_first);
         take_stat_args.push_back(&funcname);
   
         BPatch_funcCallExpr take_stat_call(*take_f[0], take_stat_args);
	 	 	 	 
         /* insert the snippet to be called */
         appProc->insertSnippet(take_stat_call, *inst_pt);

	 basic_block++;

      }
      fprintf(functions,"\n");
      appProc->finalizeInsertionSet(false);
   }
   fclose(functions);
    
   
    BPatch_Vector<BPatch_point*> *exit_p;
    BPatch_Vector<BPatch_function *> exit_f,end_f;
   
    appImage->findFunction("exit", exit_f);
    appImage->findFunction("end_program", end_f);
    exit_p = exit_f[0]->findPoint(BPatch_entry);
   
    /* Setup dump_stats to be called at exit */
    BPatch_Vector<BPatch_snippet*> end_args;
    BPatch_funcCallExpr end_prog(*end_f[0], end_args);
   
    /* insert the snippet to be called at exit */
    appProc->insertSnippet(end_prog, *exit_p);
   

    
   
   
   /* continue execution */
    appProc->continueExecution();
   /* wait for mutatee to finish while allowing Dyninst to handle events */
    while( !appProc->isTerminated() ){
        bpatch.waitForStatusChange();
    }

   return 0;
}
